/*:
 * @target MZ
 * @plugindesc Reassign the windowskin mid-game.
 * @author Caethyril
 * @help You can change the windowskin mid-game using a Script command, e.g.
 *    ChangeWindow.skin = 'Window2';
 * 
 * All windowskin images should be stored under img/system.
 * The default windowskin will be Window.png.
 * 
 * This plugin is written for RPG Maker MZ.
 */

($ => {
'use strict';

    // include skin name in save files under this identifier
    const SAVKEY = 'windowskin';

    // variable skin name
    Object.defineProperty($, 'skin', {
        get: ( ) => $._s ||= 'Window',
        set: (v) => { if ($._s !== v) $._s = v, refreshSkin(); },
        configurable: true
    });

    // refreshes active display elements
    let refreshSkin = function() {
        ColorManager.loadWindowskin();
        SceneManager._scene._windowLayer?.children.forEach(c => c.loadWindowskin?.());
    };

    // overrides to reference variable skin name
    ColorManager.loadWindowskin = function() {  // colour map (bottom-right)
        this._windowskin = ImageManager.loadSystem($.skin);
    };
    Window_Base.prototype.loadWindowskin = function() {  // window parts
        this.windowskin = ImageManager.loadSystem($.skin);
    };

    // alias to initialise skin name on new game
    void (alias => {
        DataManager.setupNewGame = function() {
            alias.apply(this, arguments), $.skin = '';
        };
    })(DataManager.setupNewGame);

    // alias to include skin name in save data
    void (alias => {
        DataManager.makeSaveContents = function() {
            const o = alias.apply(this, arguments);
            o[SAVKEY] = $.skin;
            return o;
        };
    })(DataManager.makeSaveContents);

    // alias to extract skin name from save data
    void (alias => {
        DataManager.extractSaveContents = function(contents) {
            alias.apply(this, arguments);
            $.skin = contents[SAVKEY];
        };
    })(DataManager.extractSaveContents);

})(window['ChangeWindow'] ||= {});